package com.hero.objects.powers;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.modifiers.Modifier;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class KillingAttackRanged extends Power {

	private static String xmlID = "RKA";

	public KillingAttackRanged(Element root) {
		super(root, KillingAttackRanged.xmlID);
	}

	@Override
	public String getColumn2Output() {
		String ret = getAlias() + " " + getDamageDisplay();
		if (getName().trim().length() > 0) {
			ret = "<i>" + getName() + ":</i>  " + ret;
		}
		if ((getInput() != null) && (getInput().trim().length() > 0)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			ret += " (vs. " + getInput() + ")";
		}
		if (getSelectedOption() != null) {
			ret += " (";
			ret += getSelectedOption().getAlias();

			String adderString = getAdderString();
			if (adderString.trim().length() > 0) {
				ret += "; " + adderString;
			}
			ret += ")";
		} else {
			String adderString = getAdderString();
			if (adderString.trim().length() > 0) {
				ret += " (" + adderString + ")";
			}
		}
		ret += getModifierString();
		if ((getEndUsage() > 0)
				&& (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") != null)
				&& (GenericObject.findObjectByID(getAllAssignedModifiers(),
						"ENDRESERVEOREND") == null)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			if (getUseENDReserve()) {
				ret += " (uses END Reserve)";
			} else {
				ret += " (uses Personal END)";
			}
		}
		return ret;
	}

	@Override
	public String getDamageDisplay() {
		String ret = "";
		int dc = getLevels() * 3;
		int dc2 = getLevels() * 3;
		int minus = 0;
		int stunMult = 2;

		int additional = 0;

		if (GenericObject.findObjectByID(getAllAssignedModifiers(),
				"INCREASEDSTUNMULTIPLIER") != null) {
			Modifier mod = (Modifier) GenericObject.findObjectByID(
					getAllAssignedModifiers(), "INCREASEDSTUNMULTIPLIER");
			stunMult += mod.getLevels();
		}
		if (GenericObject.findObjectByID(getAllAssignedModifiers(),
				"DECREASEDSTUNMULTIPLIER") != null) {
			Modifier mod = (Modifier) GenericObject.findObjectByID(
					getAllAssignedModifiers(), "DECREASEDSTUNMULTIPLIER");
			stunMult -= mod.getLevels();
		}
		for (Adder ad : getAssignedAdders()) {
			if (ad.getXMLID().equals("PLUSONEPIP")) {
				ad.setDisplayInString(false);
				dc += 1;
				dc2 += 1;
			}
			if (ad.getXMLID().equals("PLUSONEHALFDIE")) {
				ad.setDisplayInString(false);
				dc += 2;
				dc2 += 2;
				additional -= 1;
			}
			if (ad.getXMLID().equals("MINUSONEPIP")) {
				ad.setDisplayInString(false);
				dc += 3;
				dc2 += 3;
				minus = 1;
				additional -= 2;
			}
		}

		int dice = dc / 3;
		int rem = dc % 3;
		if (dice != 0) {
			ret += dice;
		}
		if (rem == 1) {
			if (dice > 0) {
				ret += "d6+1";
			} else {
				ret = "1 point";
			}
		} else if (rem == 2) {
			ret += " 1/2d6";
		} else {
			ret += "d6";
		}

		ret = ret.trim();

		if (minus != 0) {
			ret += "-" + minus;
		}
		if (dc != dc2) {
			ret += " / ";
			dice = dc2 / 3;
			rem = dc2 % 3;
			ret += dice;
			if (rem == 1) {
				ret += "d6+1";
			} else if (rem == 2) {
				ret += " 1/2d6";
			} else {
				ret += "d6";
			}
			if (minus != 0) {
				ret += "-" + minus;
			}
		}

		// just std effect after this point...
		dc = dc + additional;
		dc2 = dc2 + additional;

		if (useStandardEffect()) {
			if (doesBODY()) {
				ret += " (standard effect: " + dc;
				if (dc != dc2) {
					ret += " / " + dc2;
				}
				ret += " BODY, " + dc * stunMult;
				if (dc != dc2) {
					ret += " / " + dc2 * stunMult;
				}
				ret += " STUN)";
			} else {
				ret += " (standard effect: " + dc * stunMult;
				if (dc != dc2) {
					ret += " / " + dc2 * stunMult;
				}
				ret += " STUN)";
			}
		}
		return ret;
	}

}